#pragma once
#include "FileImporter.h"

namespace RTCam {

class Camera;
class Texture1D;

class LensImporter : public FileImporter
{
public:
	LensImporter(void);
	~LensImporter(void);

	bool ImportLens(_In_ ID3D11Device1* device, _In_ Camera* camera);

private:
	bool Import(_In_ ID3D11Device1* device, _In_z_ const char* filename, _In_ Camera* camera);
	bool CheckToken(_In_z_ const char* token, std::ifstream& filestream);
	shared_ptr<Texture1D> ReadChart(_In_ ID3D11Device1* device, std::ifstream& filestream, _In_z_ const char* texName);
};

} // end namespace